﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="System.Linq" %>
<%@ import Namespace="Soneta.Core" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Pożyczki na dzień</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">

	    <script runat="server">
            public class Params : ContextBase {
                public Params(Context cx) : base(cx) {
                    data = Date.Today;
                }

                Date data;
                [Priority(10)]
                [Caption("Stan na dzień")]
                public Date Data {
                    get { return data; }
                    set { data = value; }
                }
            }

            Params param = null;
            [Context]
            public Params Param {
                get { return param; }
                set { param = value; }
            }

            void OnContextLoad(Object sender, EventArgs args) {
                ReportHeader1["STAN"] = param.Data.ToString();
                ReportHeader1["DATA"] = Date.Today.ToString();
            }

            protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
                Pozyczka pozyczka = (Pozyczka)args.Row;

                if (pozyczka.Data > param.Data) {
                    args.VisibleRow = false;
                    return;
                }

                var wrk = new Pozyczka.ZaOkresInfoWorker();
                wrk.Row = pozyczka;
                wrk.Okres = new FromTo(Date.MinValid, param.Data);
        
                decimal odsetkiWszystkie = pozyczka.Raty.Sum(_ => _.Odsetki.Value);
                decimal splata = wrk.RazemSpłaty.Value + wrk.Odsetki.Value;
                decimal stanZadluzenia = pozyczka.Kwota.Value + odsetkiWszystkie - splata;

                if (stanZadluzenia <= 0) {
                    args.VisibleRow = false;
                    return;
                }
            
                Odsetki.EditValue = odsetkiWszystkie;
                Splacono.EditValue = splata;
                Pozostaje.EditValue = stanZadluzenia;
            }    
                   
	    </script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" runat="server" title="Pożyczki|</strong>Definicja: <strong>{0}|</strong>Zakres: <strong>{1}|</strong>Stan na dzień: <strong>%STAN%|</strong>Data wydruku: <strong>%DATA%"
				DataMember0="PozyczkiViewInfo+Params.Definicja" DataMember1="PozyczkiViewInfo+Params.Zakres"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Kadry.Pozyczka,Soneta.KadryPlace"
                onbeforerow="Grid1_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn Width="15" DataMember="Fundusz.Pracownik.Kod" Caption="Kod"></ea:GridColumn>
					<ea:GridColumn Align="Left" DataMember="Fundusz.Pracownik.NazwiskoImię" Caption="Nazwisko i imię"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Left" DataMember="Data" Total="Info" Caption="Pożyczka~Data udzielenia"></ea:GridColumn>
					<ea:GridColumn Width="15" Align="Right" DataMember="Kwota" Total="Sum" Caption="Pożyczka~Kwota"
						Format="{0:n}"></ea:GridColumn>
                    <ea:GridColumn Width="15" Align="Right" ID="Odsetki" Total="Sum" Caption="Pożyczka~Odsetki"
						Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Width="15" Align="Right" ID="Splacono" Total="Sum" Caption="Pożyczka~Spłaty"
						Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Width="15" Align="Right" ID="Pozostaje" Total="Sum" Caption="Pożyczka~Pozostaje"
						Format="{0:n}"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

